<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Stiffener extends Model 
{

    protected $table = 'stiffeners';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('dimensions', 'material_type', 'stiffener_type', 'panel_id');

    public function panel()
    {
        return $this->belongsTo('App\Models\Panel');
    }

}